package inc.monsters.mias.backing;

import inc.monsters.mias.data.Kid;
import inc.monsters.mias.data.KidsList;
import inc.monsters.mias.data.facade.KidService;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import javax.ejb.EJB;
import javax.faces.event.ActionEvent;

import org.apache.myfaces.trinidad.component.UIXTable;
import org.apache.myfaces.trinidad.component.core.nav.CoreCommandButton;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.SelectionEvent;

public class KidsTable {
	@EJB 
	private KidService service;
	private static final Logger log = Logger.getLogger("inc.monsters.mias");
	private UIXTable table;
	private CoreCommandButton deleteButton;
	private boolean deleteEnabled = false;
	private List<Kid> kidList;

	public UIXTable getTable() {
		return table;
	}

	public void setTable(UIXTable table) {
		this.table = table;
	}
	
	public CoreCommandButton getDeleteButton() {
		return deleteButton;
	}

	public void setDeleteButton(CoreCommandButton deleteButton) {
		this.deleteButton = deleteButton;
	}

	public boolean isDeleteEnabled() {
		return deleteEnabled;
	}

	public void setDeleteEnabled(boolean deleteEnabled) {
		this.deleteEnabled = deleteEnabled;
	}

	public void selectionChanged(SelectionEvent e) {
		log.fine("selectionChanged(): " + getTable().getSelectedRowKeys().size());
		boolean oldValue = isDeleteEnabled();
		setDeleteEnabled(getTable().getSelectedRowKeys().size() > 0);
		if(oldValue != isDeleteEnabled()) {
			RequestContext rc = RequestContext.getCurrentInstance();
		    rc.addPartialTarget(getDeleteButton());			
		}
	}
	
	public List<Kid> getKids() {
		log.fine("KidsTable.getKids() : service = " + service);
		if(null == kidList) {
			kidList = service.getKids();
		}
		log.fine("Number of Kids: " + kidList.size());

		// Fill the database with kids if there are none...
		if(kidList.size() < 1) {
			KidsList.fillDB(service);
			kidList = service.getKids();
		}
		
		return kidList;
	}	
	
	public void saveSelected(ActionEvent event) {
	    RequestContext requestContext = RequestContext.getCurrentInstance();
	    Kid k = (Kid)requestContext.getPageFlowScope().get("selectedKid");
	    log.fine("Saving kid " + k.getId() + ": " + k.getFirstName() + " " + k.getLastName() + ".");
	    if(service.existsKid(k)) {
	    	service.updateKid(k);	
	    } else {
	    	service.addKid(k);
	    }
	}
	
	public String newKid() {
	    RequestContext requestContext = RequestContext.getCurrentInstance();
	    requestContext.getPageFlowScope().put("selectedKid", new Kid());
	    return "edit";
	}
	
	public void deleteSelected(ActionEvent event) {
		Object oldRowKey = getTable().getRowKey(); // Remember the current row key of the table.
		
		Iterator<Object> selectedKeys = getTable().getSelectedRowKeys().iterator();
		int deleted = 0;
		while(selectedKeys.hasNext()) {
			Object key = selectedKeys.next();
			log.finer("Selected key = " + key);
			getTable().setRowKey(key);
			Kid kid = (Kid) getTable().getRowData();
			log.finer("Removing kid: " + kid.getId() + ": " + kid.getFirstName() + " " + kid.getLastName() + ".");
			service.deleteKid(kid);
			deleted++;
		}
		
		getTable().setSelectedRowKeys(null); // Reset the selection
		getTable().setRowKey(oldRowKey); // Reset the current row key to the remembered value.
		
		if(deleted > 0) {
			RequestContext rc = RequestContext.getCurrentInstance();
		    rc.addPartialTarget(getTable());
		}
	}
}
